//
//  SceneAnimating.swift
//
//  Copyright © 2020 Apple Inc. All rights reserved.
//


import SPCScene
import SpriteKit

public protocol SceneAnimatingDelegate {
    func sceneDidLoad(_ scene: SceneAnimating)
    mutating func sceneDidFinishAnimations(_ scene: SceneAnimating)
}

public protocol SceneAnimating {
    var animationDelegate: SceneAnimatingDelegate? { get set }
    var loadingDescription: String? { get set }
    var sceneTransition: SKTransition? { get set }
    
    func sceneIsPresented()
    func sceneWillDismiss()
}
